#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"

#include "BOLTFrm.h"
//#include "ctrl/BOLTControls.h"
#include "form/BOLTForms.h"
#include "wx/progdlg.h"

#define PROG_STEP 100
bcStatic::bcStatic(wxWindow *parent,int id,const char *label,char *table,const char *field,BOLTdb *db,RECORD_ID recID,long style):
wxStaticText(parent,id,"",wxDefaultPosition,wxDefaultSize,style,label)
//wxTextCtrl(parent,id,label,wxDefaultPosition,wxDefaultSize,style)
{
	  this->db=db;
	  this->table=table;
	  this->field=field;
	  this->recID=recID;
	  Refresh();
	  SetBackgroundColour("LIGHT GRAY");
};

void bcStatic::Refresh()
	{ lVal=db->GetValue(table,field,recID); SetLabel(lVal); };


bcQuery::bcQuery(wxWindow *parent,int id,const char *
	label,const char *query,BOLTdb *db,long style):
//wxStaticText(parent,id,"",wxDefaultPosition,wxDefaultSize,style,label)
wxTextCtrl(parent,id,label,wxDefaultPosition,wxDefaultSize,style)
{
	SetBackgroundColour(parent->GetBackgroundColour());
	SetFont(parent->GetFont());

	this->db=db;
	  this->query=query;
	  Refresh();
};

void bcQuery::SetQuery(const char *query)
{
	this->query=query;
	Refresh();
}

void bcQuery::Refresh()
{
//	lVal=db->GetQueryValue(query); SetLabel(lVal);
//	if (db->IsError()) { wxMessageBox(db->GetError(),"bcQuery Error",wxICON_HAND|wxOK,this->GetParent()); }
	if (!db) { return; }
	QRY_ID qry;
	void *row;
	char *tmp;
	wxString tStr;
	lVal="";
	qry=db->Query((char *)query.c_str(),query.Length());
	if (qry==NULL)
	{
		if (db->IsError())	{ LOG_ERROR(db->GetError()); }
	} else {
		while ((row=db->FetchRow(qry))&&(tmp=db->FetchQueryResult(qry,row,0)))
		{
				lVal.Append(tmp);
		}
	}
	db->FreeQuery(qry);

	SetLabel(lVal);
	this->GetParent()->Layout();

};

//IMPLEMENT_DYNAMIC_CLASS(bcItem,wxTextCtrl)
BEGIN_EVENT_TABLE(bcItem,wxTextCtrl)
EVT_CHAR(bcItem::OnChar)
EVT_SET_FOCUS(bcItem::OnLeave)
EVT_KILL_FOCUS(bcItem::OnLeave)
END_EVENT_TABLE()

bcItem::bcItem(wxWindow *parent,int id,
			   const char *table,const char *field,BOLTdb *db,RECORD_ID recID,const wxValidator& val,long style):
wxTextCtrl(parent,id,"",wxDefaultPosition,wxDefaultSize,(style&wxTE_MULTILINE)?style&~wxTE_PROCESS_ENTER:style,val)
		  {
				created=false;
			  m_style=style;
			  dColour=GetBackgroundColour();
			  req=false;
			  this->db=db;
			  this->table=table;
			  this->field=field;
			  this->recID=recID;
			  wxString idStr; idStr.Printf("%u",recID);
			  SetName(idStr);
			  if (!this->table.IsEmpty()) {
//				lVal=db->GetValue(table,field,recID);
				ReadValue();
				lVal=dbVal;
				SetValue(dbVal);
			  }
/*  wxAcceleratorEntry entries[1];
  entries[0].Set(wxACCEL_NORMAL,  WXK_ESCAPE,    ID_CLOSEPAGE);
  wxAcceleratorTable accel(1, entries);
  SetAcceleratorTable(accel);
  */
			  this->SetShort(FALSE);
			  created=true;
		  };

void bcItem::WriteValue(wxString& tVal)
{
	db->SetValue((char *)table.c_str(),(char *)field.c_str(),recID,(char *)tVal.c_str());
	db->SetValue((char *)table.c_str(),"updated",recID,"now()");
}

void bcItem::ReadValue()
{
  dbVal=db->GetValue((char *)table.c_str(),(char *)field.c_str(),recID);

  if (dbVal.IsEmpty()&& (this->req))
  {
	  SetBackgroundColour("PLUM");
  }
  else 
  {
	if (this->req) { SetBackgroundColour(dColour); }
  }
}

void bcItem::OnEdit()
{
	wxString tVal,fVal,cVal;

	if ((table.IsEmpty())||(!created)) { return; }
	ReadValue();
	//	dbVal=db->GetValue((char *)table.c_str(),
//		(char *)field.c_str(),recID);
	if (dbVal==lVal)
	{
		tVal=GetValue().Strip();
		if (tVal!=lVal) { // value is changed
			if (tVal.IsEmpty())
			{ 
				tVal="NULL";
				lVal="";
			} else {
				lVal=tVal;
				tVal=db->EscapeString(tVal);
				tVal.Prepend('\'');
				tVal.Append('\'');
			}
			WriteValue(tVal);
			ReadValue();
//			db->SetValue((char *)table.c_str(),(char *)field.c_str(),recID,(char *)tVal.c_str());
//			db->SetValue((char *)table.c_str(),"updated",recID,"now()");
//			dbVal=db->GetValue((char *)table.c_str(),(char *)field.c_str(),recID);
			if (!(dbVal==lVal))  //invalid data
			{
				SetForegroundColour("RED");
				wxTextCtrl::Refresh(TRUE,NULL);
				lVal=dbVal;
			} else {
				SetForegroundColour("BLACK");
				wxTextCtrl::Refresh(TRUE,NULL);
				DiscardEdits();
			}
		} else {
			SetForegroundColour("BLACK");
			wxTextCtrl::Refresh(TRUE,NULL);
			DiscardEdits();
		}
	} else { // database change
	 lVal=dbVal;
	 SetValue(dbVal);
//	 wxBell();
	};
};

void bcItem::OnLeave(wxFocusEvent &event){
	if (!this->GetParent()->IsShown()) { return; }
	if (wxGetApp().frame->closing) { return; }
	if (table.IsEmpty()) { event.Skip(); return; }
	ReadValue();
//	dbVal=db->GetValue((char *)table.c_str(),
//		(char *)field.c_str(),recID);
	if (dbVal!=GetValue())
	{
	 SetValue(dbVal);
//	 wxBell();
	}
	SetForegroundColour("BLACK");
	wxTextCtrl::Refresh(TRUE,NULL);
	DiscardEdits();
	event.Skip();
}


void bcItem::Refresh()
{
	if (!this->GetParent()->IsShown()) { return; }
	if (wxGetApp().frame->closing) { return; }
	if ((table.IsEmpty())||(!created)) { return; }
//	wxString dbVal=db->GetValue((char *)table.c_str(),
//		(char *)field.c_str(),recID);
	ReadValue();
	if (dbVal!=GetValue())
	{
//MAYBE?
		lVal=dbVal;
		SetValue(dbVal);
	}
}

void bcItem::OnChar(wxKeyEvent& event)
{
	if (event.AltDown()||event.ControlDown())
	{ event.Skip(); return; }

	switch (event.GetKeyCode())
	{
	case WXK_RETURN:
		if (m_style&~wxTE_PROCESS_ENTER)
		{event.Skip(); } else {
		event.m_keyCode=WXK_TAB;
		wxTextCtrl::OnChar(event);
		}
		break;
	case WXK_UP:
		event.m_shiftDown=true;
	case WXK_DOWN:
		event.m_keyCode=WXK_TAB;
	default:
		wxTextCtrl::OnChar(event);
		break;
	}
//	event.Skip();
};


void bcItem::OnKeyUp(wxKeyEvent &event)
{
	if (event.GetKeyCode()==WXK_ESCAPE)
	{
		GetParent()->SetFocus();
	} else { event.Skip(); }
	
//	wxTextCtrl::OnKeyUp(event);
//	event.Skip();
}

//IMPLEMENT_DYNAMIC_CLASS(bcDateItem,wxTextCtrl)
BEGIN_EVENT_TABLE(bcDateItem,wxTextCtrl)
EVT_CHAR(bcDateItem::OnChar)
EVT_SET_FOCUS(bcDateItem::OnLeave)
EVT_KILL_FOCUS(bcDateItem::OnLeave)
END_EVENT_TABLE()

bcDateItem::bcDateItem(wxWindow *parent,int id,
			   char *table,char *field,BOLTdb *db,RECORD_ID recID,const wxValidator& val,long style):
			bcItem(parent,id,table,field,db,recID,val,style)
		  {
				ReadValue();
				lVal=dbVal;
				Seperator="/";
		  };

void bcDateItem::ReadValue()
{
wxString tStr;
tStr.Printf("DATE_FORMAT(%s,'%%m%s%%d%s%%Y')",field.c_str(),Seperator.c_str(),Seperator.c_str());
dbVal=db->GetValue(table.c_str(),tStr.c_str(),recID);
  if (dbVal.IsEmpty()&& (this->req))
  {
	  SetBackgroundColour("PLUM");
  }//set dbVal
  else 
  {
	if (this->req) { SetBackgroundColour(dColour); }
  }
}

void bcDateItem::WriteValue(wxString &tVal)
{
	wxString sMonth,sDay,sYear,tStr;
	unsigned long iMonth,iDay,iYear;
	char seps[]="/-.";
	int i;
	bool found=false;
	if (tVal.IsEmpty() || tVal=="NULL")
	{
	db->SetValue(table.c_str(),field.c_str(),this->recID,"null");
	}
	else
	{
	//find the seperator character
	for (i=-1; (i<3)&&(!found);)
	{ found=tVal.Contains(seps[++i]); }

	if (i>=3) { 
		if (tVal.Length() >= 8)
		{
			tStr.Printf("'%s-%s-%s",tVal.Mid(1,2).c_str(),tVal.Mid(3,2).c_str(),tVal.Mid(5,5).c_str());
			tVal=tStr; i=1;
		} else 
		{
		return; 
		}
	}
	this->Seperator=seps[i];
	sMonth=tVal.AfterFirst('\'').BeforeFirst(seps[i]);
	tStr=tVal.AfterFirst(seps[i]);
	sDay=tStr.BeforeFirst(seps[i]);
	sYear=tStr.AfterLast(seps[i]).BeforeFirst('\'');

	sMonth.ToULong(&iMonth);
	sDay.ToULong(&iDay);
	sYear.ToULong(&iYear);

	tStr.Printf("'%u-%u-%u'",iYear,iMonth,iDay);
	db->SetValue(table.c_str(),field.c_str(),this->recID,tStr.c_str());
}
	db->SetValue((char *)table.c_str(),"updated",recID,"now()");
	ReadValue();
}

//IMPLEMENT_DYNAMIC_CLASS(bcPhoneItem,wxTextCtrl)
BEGIN_EVENT_TABLE(bcPhoneItem,wxTextCtrl)
EVT_CHAR(bcPhoneItem::OnChar)
EVT_SET_FOCUS(bcPhoneItem::OnLeave)
EVT_KILL_FOCUS(bcPhoneItem::OnLeave)
END_EVENT_TABLE()

bcPhoneItem::bcPhoneItem(wxWindow *parent,int id,
			   char *table,char *field,BOLTdb *db,RECORD_ID recID,const wxValidator& val,long style):
			bcItem(parent,id,table,field,db,recID,val,style)
		  {
				this->Seperator="/";
				ReadValue();
				lVal=dbVal;
				SetValue(dbVal);

		  };

void bcPhoneItem::WriteValue(wxString &tVal)
{
	wxString tStr;
//	bool found=false;
	long curs;
	if (tVal.IsEmpty() || tVal=="NULL")
	{
	db->SetValue(table.c_str(),field.c_str(),this->recID,"null");
	}
	else
	{
		curs=GetInsertionPoint();
		tStr=tVal.BeforeLast('\'').AfterFirst('\'');
		if (tStr.Length()==1 && tStr.IsNumber())
		{ tStr.Prepend('(');curs++; }
		if (tStr.Length()==4)
		{ tStr.Append(')');curs++;  }
		if (tStr.Length()==8)
		{ tStr.Append('-');curs++;  }

		tVal=db->EscapeString(tStr.c_str());
		tVal.Prepend("'");
		tVal.Append("'");
		db->SetValue(table.c_str(),field.c_str(),this->recID,tVal.c_str());
		this->Refresh();
		SetInsertionPoint(curs);
//		ReadValue();
	}

	db->SetValue((char *)table.c_str(),"updated",recID,"now()");
//	ReadValue();
}

bcQueryList::bcQueryList(BOLTdb *dbase,wxWindow* parent, 
	wxWindowID id, wxString& label, long style): 
wxTreeCtrl(parent,id,wxDefaultPosition,wxDefaultSize,wxTR_HAS_BUTTONS|wxTR_SINGLE|wxTR_LINES_AT_ROOT|wxTR_HIDE_ROOT|wxTR_ROW_LINES)
{
	db=dbase;
	this->label=label;
	AddRoot(label);

	SetFont(wxGetApp().frame->fixedFont);
};

bcQueryList::~bcQueryList()
{
	ClearQueries();
};

class bcItemData: public wxTreeItemData
{
public:
	RECORD_ID recordID;

	bcItemData(RECORD_ID RecordID): 
		wxTreeItemData()
	{
		this->recordID = RecordID;
		this->title=NULL;
		this->query=NULL;
		this->color=NULL;
		this->subQuery=NULL;
//		this->title="";
//		this->query="";
//		color=wxColour("WHITE");
	}
	virtual ~bcItemData(){
		if (title) safe_delete(title);
		if (query) safe_delete(query);
		if (subQuery) safe_delete(subQuery);
		if (color) safe_delete(color);
	}
	void SetQTitle(wxString & tit)
	{ if (title) safe_delete(title); title=new wxString(tit);}
	wxString GetQTitle()
	{ if (title) return *title; else { SetQTitle(wxString("")); return *title; } }
	void SetQuery(wxString & qry)
	{ if (query) safe_delete(query); query=new wxString(qry);}
	wxString GetQuery()
	{ if (query) return *query; else { SetQuery(wxString(""));return *query; } }
	void SetSubQuery(wxString & qry)
	{ if (subQuery) safe_delete(subQuery); subQuery=new wxString(qry);}
	wxString GetSubQuery()
	{ if (subQuery) return *subQuery; else { SetSubQuery(wxString(""));return *subQuery; } }
	void SetQColour(wxColour & col)
	{ if (color) safe_delete(color); color=new wxColour(col);}
	wxColour GetQColour()
	{ if (color) return *color; else { SetQColour(wxColour("WHITE")); return *color; } }

private:
	wxString *title;
	wxString *query;
	wxString *subQuery;
	wxColour *color;
};

//IMPLEMENT_DYNAMIC_CLASS(bcQueryList,wxTreeCtrl)
BEGIN_EVENT_TABLE(bcQueryList,wxTreeCtrl)
EVT_KEY_UP(bcQueryList::OnKey)
END_EVENT_TABLE()

void bcQueryList::Refresh()
{
	QRY_ID qry;
	void *row;
	wxTreeItemId groupID;
	wxString query,name;
	unsigned int x;
	unsigned int l;
	wxString lblStr;
	RECORD_ID qId;
	bcItemData *tBID;
	char *tmp;

	ClearQueries();
	for (x=0;x<this->queryNames.Count();x++)
	{
		query=this->queryText[x];
		name=this->queryNames[x];
		qry=db->Query(query.c_str(),query.Length());
		if (qry==NULL)
		{
			if (db->IsError())
			{ LOG_ERROR(db->GetError()); }
			return; 
		}
		int i=0;
		groupID=AppendItem(GetRootItem(),name,-1,-1,0);
		while (row=db->FetchRow(qry))
		{
			i++;
			if (tmp=db->FetchQueryResult(qry,row,0))
			{
				qId=atoi(tmp);
				lblStr="";
				l=1;
				while (l<db->FetchNumCols(qry,row))
				{ 
					if (tmp=db->FetchQueryResult(qry,row,l++))
					{ lblStr.Append(tmp); }
				}
				if (tBID=new bcItemData(qId))
				{
				AppendItem(groupID,lblStr,-1,-1,tBID);
				}
			}
		}
		db->FreeQuery(qry);

		if(i)
		{/*	Expand(GetRootItem());	*/} else { Delete(groupID); }
	}
}

bool bcQueryList::AddQuery(wxString &name, wxString &query, const char *col, wxString &subQuery)
{
//	QRY_ID qry;
//	void *row;
	wxTreeItemId groupID;
	this->queryNames.Add(name);
	this->queryText.Add(query);

	bcItemData *tData=new bcItemData(0);
	tData->SetQTitle(name);
	tData->SetQuery(query);
	if (!subQuery.IsEmpty())
	{
	tData->SetSubQuery(subQuery);
	}
	tData->SetQColour(wxColour(col));

	groupID=AppendItem(GetRootItem(),name,-1,-1,tData);
	SetItemHasChildren(groupID,TRUE);
	SetItemBackgroundColour(groupID,col);
//	if (groupID!=GetRootItem())
//	{
//			Expand(GetRootItem());
//	}

	return TRUE;
};

bool bcQueryList::AddQuery(wxString& name,wxString& query,const char *col)
{ 
	return AddQuery(name,query,col,wxString(""));
}

bool bcQueryList::AddQuery(const char *name,const char *query,const char *col)
{
	wxString wName,wQry;
	wName.Printf("%s",name);
	wQry.Printf("%s",query);
	return AddQuery(wName,wQry,col);
}

void bcQueryList::DeleteItemData(wxTreeItemId itemId)
{
	wxTreeItemId childId;
	long cookie;
	bcItemData *tData;

	for (childId=GetFirstChild(itemId,cookie);
		childId.IsOk();
		childId=GetNextChild(itemId,cookie))
		{ DeleteItemData(childId); }
	
	tData = (bcItemData *)GetItemData(itemId);
	if (tData) { safe_delete(tData); }
	SetItemData(itemId,0);
}

bool bcQueryList::ClearQueries()
{

//start at the root, delete all children
	wxTreeItemId childId;
	long cookie;

	for (childId=GetFirstChild(GetRootItem(),cookie);
		childId.IsOk();
		childId=GetNextChild(GetRootItem(),cookie))
		{ DeleteItemData(childId); }

	DeleteAllItems();
	AddRoot(label,-1,-1,0);
		return(TRUE);
};

RECORD_ID bcQueryList::GetChoice()
{
	bcItemData *tData=NULL;
	wxTreeItemId id;
	id=GetSelection();
	if (id.IsOk())
	tData=(bcItemData *)GetItemData(GetSelection());
	if (tData) { return(tData->recordID); }
	return(0);
};

void bcQueryList::OnKey(wxKeyEvent &event)
{
if (event.GetKeyCode()==WXK_TAB)
{
wxNavigationKeyEvent eventNav;
eventNav.SetDirection(!event.ShiftDown());
eventNav.SetWindowChange(event.ControlDown());
if ( wxWindow::GetParent()->GetEventHandler()->ProcessEvent(eventNav) )
    return;
}
if (event.GetKeyCode()==WXK_RETURN)
{
	//Generate an activate event
	wxTreeEvent tEvt(wxEVT_COMMAND_TREE_ITEM_ACTIVATED,this->GetId());
	tEvt.SetEventObject(this);
	if ( wxWindow::GetParent()->GetEventHandler()->ProcessEvent(tEvt) )
    return;	
}
//GetEventHandler()->ProcessEvent(event);
event.Skip();
}

void bcQueryList::OnExpand(wxTreeEvent &event)
{
//if itemdata has title/query
	//fill this item with query
	QRY_ID qry;	
	void *row;
	wxTreeItemId groupID,newId;
	wxString query;
	bcItemData *tData=NULL,*nItem;
	wxProgressDialog  *prog;
	wxTreeItemId id;
	char *tmp;
	wxString tStr;
	RECORD_ID recId;
	unsigned int l;	

	int cnt=0;
	wxString progStr;
	bool cont=true;

	if (!event.GetItem().IsOk())
	{ return; }
	tData=(bcItemData *)GetItemData(event.GetItem());
	if (!tData) { return; } 
	SetFont(wxGetApp().frame->fixedFont);
	//if itemdata has stitle/query
	if (tData->GetQuery().IsEmpty())
	{ return; }

	if (IsExpanded(event.GetItem())) { return; }//collapse first
	//run query - fill item
	wxBeginBusyCursor();
Enable(FALSE);
	query=tData->GetQuery();
	prog=new wxProgressDialog("Getting Information","Asking Database",1,this->GetParent(),wxPD_APP_MODAL);
	qry=db->Query((char *)query.c_str(),query.Length());
	delete prog;//prog->Destroy();
	if (qry==NULL)
	{
		wxEndBusyCursor();
		Enable(TRUE);
		if (db->IsError()) { LOG_ERROR(db->GetError()); }
		return;
	}
	groupID=event.GetItem();
	SetItemBackgroundColour(groupID,tData->GetQColour());
	int max=db->FetchNumRows(qry);
	prog=new wxProgressDialog("Getting Information","Fetching Data",max,this,wxPD_CAN_ABORT|wxPD_REMAINING_TIME|wxPD_AUTO_HIDE);
	while ( ((row=db->FetchRow(qry))!=NULL)&& (cont))
	{
		if ((++cnt % PROG_STEP)==0) //update progress
		{
			progStr.Printf("Fetching %d to %d of %d",cnt,cnt+PROG_STEP-1,max);
			cont=prog->Update(cnt,progStr);
		}

		if (tmp=db->FetchQueryResult(qry,row,0))
		{ 
			recId = atoi(tmp); 
			tStr="";l=1;
			while (l<db->FetchNumCols(qry,row))
			{ 
				if (tmp=db->FetchQueryResult(qry,row,l++))
				{	tStr.Append(tmp); }
			}

			nItem=new bcItemData(recId);
			if (!tData->GetSubQuery().IsEmpty())
			{
				wxString cStr,rStr;
				rStr.Printf("%u",recId);
				cStr=tData->GetSubQuery();
				cStr.Replace("%ID%",rStr.c_str());
				nItem->SetQuery(cStr);
				nItem->SetQColour(tData->GetQColour());

			}

			if (!nItem)
			{	LOG_ERROR("Out of Memory on Query List"); }
			else
			{			
				newId=AppendItem(groupID,
					tStr,
					-1,-1,nItem);		
				if (newId.IsOk())
				{
					SetItemBackgroundColour(newId,tData->GetQColour());
					SetItemFont(newId,wxGetApp().frame->fixedFont);
					// subQuery
						SetItemHasChildren(newId,!tData->GetSubQuery().IsEmpty());
						// create a new tItemData, move subQuery to query
				} else { LOG_ERROR("Could not Add Item to Query List"); }
			}
		}
	}
	if (cnt==0)
	{
		SetItemHasChildren(groupID,FALSE);
	}
	Enable(TRUE);
	delete prog;//prog->Destroy();
	db->FreeQuery(qry);
	wxEndBusyCursor();

}

void bcQueryList::OnColapse(wxTreeEvent &event)
{
	bcItemData *tData=NULL;
	wxTreeItemId id;
	if (event.GetItem().IsOk())
	tData=(bcItemData *)GetItemData(event.GetItem());
	if (tData) { 
	//if itemdata has stitle/query
		if (!tData->GetQuery().IsEmpty())
		{
	//clear item
			CollapseAndReset(event.GetItem());
		}
	}
}

//IMPLEMENT_DYNAMIC_CLASS(bcChoice,wxChoice)
//BEGIN_EVENT_TABLE(bcChoice,wxRadioBox)
BEGIN_EVENT_TABLE(bcChoice,wxChoice)
END_EVENT_TABLE()

bcChoice::bcChoice(wxWindow *parent,int id,const char *label,int n, const wxString choices[],char *table,char *field,BOLTdb *db,RECORD_ID recID,long style):
//	 wxRadioBox(parent,id,label,wxDefaultPosition,wxDefaultSize,n,choices,style)
	wxChoice(parent,id,wxDefaultPosition,wxDefaultSize,n,choices,style)
{
	this->db=db;
	this->recID=recID;
	this->table=table;
	this->field=field;
	char *tmp;
	if (tmp=db->GetValue(table,field,recID))
	{
		SetSelection(atoi(tmp));
	}
}

void bcChoice::OnChoice(wxCommandEvent & event)
{
	int s;
	wxString tStr;
	s=GetSelection();
//todo - read and check first
	if (s>-1)
	{
		tStr.Printf("%d",s);
		db->SetValue(table.c_str(),field.c_str(),recID,tStr.c_str());
	}
	event.Skip();
}

void bcChoice::Refresh()
{
	char *tmp;
	if (tmp=db->GetValue(table.c_str(),field.c_str(),recID))
	{
		SetSelection(atoi(tmp));
	}

}

void bcChoice::OnRadioBox(wxCommandEvent &event)
{
	bcChoice *item;
	item = (bcChoice *)event.GetEventObject();
	if (item) { item->OnChoice(event);}
}

BEGIN_EVENT_TABLE(bcChoiceText,wxChoice)
END_EVENT_TABLE()

bcChoiceText::bcChoiceText(wxWindow *parent,int id,const char *label,int n, const wxString choices[],char *table,char *field,BOLTdb *db,RECORD_ID recID,long style):
//	 wxRadioBox(parent,id,label,wxDefaultPosition,wxDefaultSize,n,choices,style)
	wxChoice(parent,id,wxDefaultPosition,wxDefaultSize,n,choices,style)
{
	this->db=db;
	this->recID=recID;
	this->table=table;
	this->field=field;
	char *tmp;
	if (tmp=db->GetValue(table,field,recID))
	{
		SetSelection(atoi(tmp));
	}
}

void bcChoiceText::OnChoice(wxCommandEvent & event)
{
//	int s;
	wxString tStr;
	wxString tVal;
	tVal=GetStringSelection();
//todo - read and check first
	if (!tVal.IsEmpty())
	{
		tStr.Printf("'%s'",tVal.c_str());
		db->SetValue(table.c_str(),field.c_str(),recID,tStr.c_str());
	}
	event.Skip();
}

void bcChoiceText::Refresh()
{
	char *tmp;
	if (tmp=db->GetValue(table.c_str(),field.c_str(),recID))
	{
		if (FindString(tmp) > -1) {
		SetStringSelection(tmp);
		}
	}

}

void bcChoiceText::OnRadioBox(wxCommandEvent &event)
{
	bcChoiceText *item;
	item = (bcChoiceText *)event.GetEventObject();
	if (item) { item->OnChoice(event);}
}



void bcItem::SetShort(bool isShort)
{
 this->showShort=isShort;
 Refresh();
}

void bcItem::MakeRequired(bool req)
{
	this->req=req;
	Refresh();
}



bool bcQueryList::AddQuery(const char *name, const char *query, const char *col, const char *subQuery)
{
	wxString wName,wQry,sQry;
	wName.Printf("%s",name);
	wQry.Printf("%s",query);
	sQry.Printf("%s",subQuery);
	return AddQuery(wName,wQry,col,sQry);
}
